
unit WebForm3;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls;

type
  TWebForm3 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
		TopHolder: System.Web.UI.WebControls.PlaceHolder;
		CategoriesHolder: System.Web.UI.WebControls.PlaceHolder;
		ProdInCatHolder: System.Web.UI.WebControls.PlaceHolder;
		topicHeading: System.Web.UI.WebControls.Label;
		topicDescription: System.Web.UI.WebControls.Label;
    procedure OnInit(e: EventArgs); override;
  end;

implementation


uses catgrid, productsDB, top, apptypes;

var _top : CSTop;
    _AppTypes : csAppTypes;

procedure TWebForm3.Page_Load(sender: System.Object; e: System.EventArgs);
	var
		product : TproductsDB;
		KatName : string;
		AppPayType : string;
    _CatGrid : TCatGrid;
begin
  		_CatGrid := TCatGrid.create;
    ProdInCatHolder.Controls.Add(_CatGrid);

		product:=TproductsDB.Create;

			KatName := Request.QueryString.Get('AppType');
			AppPayType := Request.QueryString.Get('AppPayType');

			if KatName<>'' then
			begin
				topicHeading.Text:=KatName;
				topicDescription.Text:='Browse by category...';
				_CatGrid.ShowBy := sbAppType;
				_CatGrid.DataSource := product.GetProductsInCategory(KatName);
			end;
			if AppPayType<>'' then
			begin
				topicHeading.Text:=AppPayType;
				topicDescription.Text:='Browse by type...';
				_CatGrid.ShowBy := sbAppPayType;
				_CatGrid.DataSource := product.GetProductsInPayType(AppPaytype);
			end;


			//if not IsPostBack then
			begin
				try
					_CatGrid.EnableViewState:=false;
					_CatGrid.DataBind;
				except
					topicHeading.Text:='Error!';
				end;

				if (_CatGrid.DataSource as DataTable).Rows.Count = 0 then
					ProdInCatHolder.Controls.Add(LiteralControl.Create('No matching records found!'));

				if _CatGrid.PageCount = 1 then
					_CatGrid.PagerStyle.Visible := False;
			end;

end;

procedure TWebForm3.OnInit(e: EventArgs);
begin
  //
  // CODEGEN: This call is required by the ASP.NET Web Form Designer.
  //
  InitializeComponent;
  inherited OnInit(e);

      _AppTypes := csAppTypes.create;
      CategoriesHolder.Controls.Add(_AppTypes);
      _AppTypes.Free;

      _top := CSTop.create;
      TopHolder.Controls.Add(_top);
      _top.Free;
end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm3.InitializeComponent;
begin
	Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


end.

